import { afterEach, vi } from 'vitest';
let env = {};
export function setEnv(newEnv) {
    env = { ...env, ...newEnv };
}
/** Static env mock - to be used inside `vi.mock` */
export async function mockEnv(options) {
    const initialEnv = options?.env ?? {};
    const withDefaults = options && 'withDefaults' in options ? options.withDefaults : true;
    env = { ...initialEnv };
    afterEach(() => {
        env = { ...initialEnv };
    });
    const { defaults, processValues } = await vi.importActual('../env.js');
    return {
        get default() {
            return processValues({ ...(withDefaults && defaults), ...env });
        },
    };
}
/** Dynamic env mock */
export function doMockEnv(options) {
    const initialEnv = options?.env ?? {};
    const withDefaults = options && 'withDefaults' in options ? options.withDefaults : true;
    let env = { ...initialEnv };
    vi.doMock('../env.js', async () => {
        const { defaults, processValues } = await vi.importActual('../env.js');
        return {
            get default() {
                return processValues({ ...(withDefaults && defaults), ...env });
            },
        };
    });
    afterEach(() => {
        env = { ...initialEnv };
    });
    return { env, setEnv };
    function setEnv(newEnv) {
        env = { ...env, ...newEnv };
    }
}
