"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isValidationErrorLike = exports.isValidationError = exports.toValidationError = exports.fromZodError = exports.ValidationError = void 0;
const zod = __importStar(require("zod"));
const joinPath_1 = require("./utils/joinPath");
class ValidationError extends Error {
    details;
    name;
    constructor(message, details = []) {
        super(message);
        this.details = details;
        this.name = 'ZodValidationError';
    }
    toString() {
        return this.message;
    }
}
exports.ValidationError = ValidationError;
function fromZodIssue(issue, issueSeparator, unionSeparator) {
    if (issue.code === 'invalid_union') {
        return issue.unionErrors
            .reduce((acc, zodError) => {
            const newIssues = zodError.issues
                .map((issue) => fromZodIssue(issue, issueSeparator, unionSeparator))
                .join(issueSeparator);
            if (!acc.includes(newIssues)) {
                acc.push(newIssues);
            }
            return acc;
        }, [])
            .join(unionSeparator);
    }
    if (issue.path.length > 0) {
        return `${issue.message} at "${(0, joinPath_1.joinPath)(issue.path)}"`;
    }
    return issue.message;
}
function fromZodError(zodError, options = {}) {
    const { maxIssuesInMessage = 99, issueSeparator = '; ', unionSeparator = ', or ', prefixSeparator = ': ', prefix = 'Validation error', } = options;
    const reason = zodError.errors
        .slice(0, maxIssuesInMessage)
        .map((issue) => fromZodIssue(issue, issueSeparator, unionSeparator))
        .join(issueSeparator);
    const message = reason ? [prefix, reason].join(prefixSeparator) : prefix;
    return new ValidationError(message, zodError.errors);
}
exports.fromZodError = fromZodError;
const toValidationError = (options = {}) => (err) => {
    if (err instanceof zod.ZodError) {
        return fromZodError(err, options);
    }
    if (err instanceof Error) {
        return err;
    }
    return new Error('Unknown error');
};
exports.toValidationError = toValidationError;
function isValidationError(err) {
    return err instanceof ValidationError;
}
exports.isValidationError = isValidationError;
function isValidationErrorLike(err) {
    return err instanceof Error && err.name === 'ZodValidationError';
}
exports.isValidationErrorLike = isValidationErrorLike;
