import env from '../../../../env.js';
import logger from '../../../../logger.js';
export async function callReference(fn, args) {
    const sandboxTimeout = Number(env['EXTENSIONS_SANDBOX_TIMEOUT']);
    try {
        return await fn.apply(undefined, args, {
            arguments: { copy: true },
            result: { reference: true, promise: true },
            timeout: sandboxTimeout,
        });
    }
    catch (e) {
        if (e instanceof RangeError) {
            logger.error(`Extension sandbox has reached the memory limit`);
            logger.error(e);
            process.abort();
        }
        throw e;
    }
}
