import { isEqual } from 'lodash-es';
import getDatabase from '../database/index.js';
import emitter from '../emitter.js';
import asyncHandler from '../utils/async-handler.js';
import { getAccountabilityForToken } from '../utils/get-accountability-for-token.js';
import { getIPFromReq } from '../utils/get-ip-from-req.js';
/**
 * Verify the passed JWT and assign the user ID and role to `req`
 */
export const handler = async (req, _res, next) => {
    const defaultAccountability = {
        user: null,
        role: null,
        admin: false,
        app: false,
        ip: getIPFromReq(req),
    };
    const userAgent = req.get('user-agent');
    if (userAgent)
        defaultAccountability.userAgent = userAgent;
    const origin = req.get('origin');
    if (origin)
        defaultAccountability.origin = origin;
    const database = getDatabase();
    const customAccountability = await emitter.emitFilter('authenticate', defaultAccountability, {
        req,
    }, {
        database,
        schema: null,
        accountability: null,
    });
    if (customAccountability && isEqual(customAccountability, defaultAccountability) === false) {
        req.accountability = customAccountability;
        return next();
    }
    req.accountability = await getAccountabilityForToken(req.token, defaultAccountability);
    return next();
};
export default asyncHandler(handler);
