import type { ApiOutput, ExtensionSettings } from '@directus/extensions';
import type { SchemaInspector } from '@directus/schema';
import type { Accountability, DeepPartial, SchemaOverview } from '@directus/types';
import type Keyv from 'keyv';
import type { Knex } from 'knex';
import type { Helpers } from '../database/helpers/index.js';
import type { ExtensionManager } from '../extensions/manager.js';
import type { AbstractServiceOptions } from '../types/index.js';
import { ItemsService } from './items.js';
import { PermissionsService } from './permissions.js';
export declare class ExtensionsService {
    knex: Knex;
    permissionsService: PermissionsService;
    schemaInspector: SchemaInspector;
    accountability: Accountability | null;
    schema: SchemaOverview;
    extensionsItemService: ItemsService<ExtensionSettings>;
    systemCache: Keyv<any>;
    helpers: Helpers;
    extensionsManager: ExtensionManager;
    constructor(options: AbstractServiceOptions);
    readAll(): Promise<ApiOutput[]>;
    readOne(bundle: string | null, name: string): Promise<ApiOutput>;
    updateOne(bundle: string | null, name: string, data: DeepPartial<ApiOutput>): Promise<void>;
    private getKey;
    /**
     * Combine the settings stored in the database with the information available from the installed
     * extensions into the standardized extensions api output
     */
    private stitch;
}
